<?php
// Include database connection
include 'conn.php';

// Initialize message variable
$message = "";

// Initialize variables to hold form data
$book_no = "";
$book_name = "";
$subject = "";
$form = "";
$retain_values = isset($_POST['retain_values']) ? $_POST['retain_values'] : '';

// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve and sanitize form data
    $book_no = $_POST['book_no'];
    $book_name = $_POST['book_name'];
    $subject = $_POST['subject'];
    $form = $_POST['form'];

    // Sanitize input
    $book_no = $conn->real_escape_string($book_no);
    $book_name = $conn->real_escape_string($book_name);
    $subject = $conn->real_escape_string($subject);
    $form = $conn->real_escape_string($form);

    // Check if the book_no already exists
    $check_sql = "SELECT * FROM books WHERE book_no='$book_no'";
    $check_result = $conn->query($check_sql);

    if ($check_result->num_rows > 0) {
        // Book already exists
        $message = "<div class='message error'>Error: Book with number $book_no already exists.</div>";
    } else {
        // Insert data into the database
        $sql = "INSERT INTO books (book_no, book_name, subject, form) VALUES ('$book_no', '$book_name', '$subject', '$form')";

        if ($conn->query($sql) === TRUE) {
            $message = "<div class='message success'>New record created successfully</div>";
            // Always clear book_no, retain other fields based on checkbox
            $book_no = "";
            if (!$retain_values) {
                $book_name = "";
                $subject = "";
                $form = "";
            }
        } else {
            $message = "<div class='message error'>Error: " . $sql . "<br>" . $conn->error . "</div>";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Insert Book</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
            background: linear-gradient(135deg, #e3f2fd, #bbdefb); /* Smooth light blue gradient */
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .navbar {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            background: rgba(255, 255, 255, 0.9);
            border-bottom: 1px solid #b3e5fc; /* Light blue border */
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            padding: 10px 20px;
            display: flex;
            align-items: center;
            z-index: 1000;
            backdrop-filter: blur(8px); /* Subtle blur effect */
            box-sizing: border-box;
            animation: fadeIn 1s ease-in-out;
        }
        .clock {
            font-size: 28px;
            color: #0288d1; /* Primary blue */
            font-weight: bold;
            margin-right: 20px;
        }
        .nav-links {
            display: flex;
            flex: 1;
            justify-content: center;
        }
        .nav-links a {
            text-decoration: none;
            color: #0288d1; /* Primary blue */
            font-size: 16px;
            margin: 0 15px;
            font-weight: 500;
            display: flex;
            align-items: center;
            transition: color 0.3s ease, transform 0.3s ease;
        }
        .nav-links a i {
            margin-right: 8px;
        }
        .nav-links a:hover {
            color: #01579b; /* Darker blue on hover */
            transform: scale(1.1);
        }
        .container {
            width: 70vw;
            max-width: 800px;
            padding: 20px;
            background-color: #ffffff;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            box-sizing: border-box;
            margin: 80px auto 20px; /* Center the container and account for fixed navbar */
            animation: fadeIn 1s ease-in-out;
        }
        h2 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
            font-size: 24px;
        }
        .form-group {
            margin-bottom: 15px;
            position: relative;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #666;
            font-weight: 500;
        }
        .form-group input, .form-group select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            box-sizing: border-box;
            transition: border-color 0.3s ease;
        }
        .form-group input:focus, .form-group select:focus {
            border-color: #0288d1; /* Primary blue for focus state */
            outline: none;
        }
        .btn-submit {
            width: 100%;
            padding: 12px;
            background-color: #0288d1; /* Primary blue */
            color: #ffffff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            transition: background-color 0.3s, transform 0.3s;
        }
        .btn-submit:hover {
            background-color: #01579b; /* Darker blue on hover */
            transform: scale(1.05);
        }
        .message {
            text-align: center;
            margin-top: 20px;
            padding: 10px;
            border-radius: 5px;
            font-size: 16px;
        }
        .message.success {
            color: #28a745;
            border: 1px solid #28a745;
            background-color: #d4edda;
        }
        .message.error {
            color: #dc3545;
            border: 1px solid #dc3545;
            background-color: #f8d7da;
        }
        .retain-values {
            margin-top: 10px;
            font-size: 14px;
        }
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
</head>
<body>
    <div class="navbar">
        <div id="clock" class="clock"></div>
        <div class="nav-links">
            <a href="give_book.php"><i class="fas fa-home"></i> Give Book</a>
            <a href="returnbook.php"><i class="fas fa-book-return"></i> Return Book</a>
            <a href="add_student.php"><i class="fas fa-user-plus"></i> Add New Student</a>
            <a href="search_report.php"><i class="fas fa-file-alt"></i> Generate Report</a>
        </div>
    </div>

    <div class="container">
        <h2><i class="fas fa-book"></i> Insert Book</h2>
        <form method="post" action="">
            <div class="form-group">
                <label for="book_no">Book Number</label>
                <input type="text" id="book_no" name="book_no" value="<?php echo htmlspecialchars($book_no); ?>" required>
                <i class="fas fa-barcode barcode-icon"></i>
            </div>
            <div class="form-group">
                <label for="book_name">Book Name</label>
                <input type="text" id="book_name" name="book_name" value="<?php echo htmlspecialchars($book_name); ?>" required>
            </div>
            <div class="form-group">
                <label for="subject">Subject</label>
                <select id="subject" name="subject" required>
                    <option value="">Select a Subject</option>
                    <option value="Mathematics" <?php echo ($subject == 'Mathematics') ? 'selected' : ''; ?>>Mathematics</option>
                    <option value="English" <?php echo ($subject == 'English') ? 'selected' : ''; ?>>English</option>
                    <option value="Kiswahili" <?php echo ($subject == 'Kiswahili') ? 'selected' : ''; ?>>Kiswahili</option>
                    <option value="Physics" <?php echo ($subject == 'Physics') ? 'selected' : ''; ?>>Physics</option>
                    <option value="Chemistry" <?php echo ($subject == 'Chemistry') ? 'selected' : ''; ?>>Chemistry</option>
                    <option value="Biology" <?php echo ($subject == 'Biology') ? 'selected' : ''; ?>>Biology</option>
                    <option value="CRE" <?php echo ($subject == 'CRE') ? 'selected' : ''; ?>>CRE</option>
                    <option value="ISLAM" <?php echo ($subject == 'ISLAM') ? 'selected' : ''; ?>>ISLAM</option>
                    <option value="Geography" <?php echo ($subject == 'Geography') ? 'selected' : ''; ?>>Geography</option>
                    <option value="History" <?php echo ($subject == 'History') ? 'selected' : ''; ?>>History</option>
                    <option value="Computer" <?php echo ($subject == 'Computer') ? 'selected' : ''; ?>>Computer</option>
                    <option value="French" <?php echo ($subject == 'French') ? 'selected' : ''; ?>>French</option>
                    <option value="Business" <?php echo ($subject == 'Business') ? 'selected' : ''; ?>>Business</option>
                    <option value="Agriculture" <?php echo ($subject == 'Agriculture') ? 'selected' : ''; ?>>Agriculture</option>
                    <option value="Aviation" <?php echo ($subject == 'Aviation') ? 'selected' : ''; ?>>Aviation</option>
                    <option value="Germany" <?php echo ($subject == 'Germany') ? 'selected' : ''; ?>>Germany</option>
                    <option value="World" <?php echo ($subject == 'World') ? 'selected' : ''; ?>>World</option>
                    <option value="Fiction" <?php echo ($subject == 'Fiction') ? 'selected' : ''; ?>>Fiction</option>
                    <option value="Revision Book" <?php echo ($subject == 'Revision Book') ? 'selected' : ''; ?>>Revision Book</option>
                    <option value="Others" <?php echo ($subject == 'Others') ? 'selected' : ''; ?>>Others</option>
                </select>
            </div>
            <div class="form-group">
                <label for="form">Form</label>
                <input type="text" id="form" name="form" value="<?php echo htmlspecialchars($form); ?>">
            </div>
            <div class="form-group retain-values">
                <label>
                    <input type="checkbox" name="retain_values" <?php echo ($retain_values == 'on') ? 'checked' : ''; ?>>
                    Retain input values (except Book Number)
                </label>
            </div>
            <button type="submit" class="btn-submit"><i class="fas fa-plus"></i> Add Book</button>
            <?php echo $message; ?>
        </form>
    </div>

    <script>
        // Update clock every second
        function updateClock() {
            const now = new Date();
            const hours = now.getHours().toString().padStart(2, '0');
            const minutes = now.getMinutes().toString().padStart(2, '0');
            const seconds = now.getSeconds().toString().padStart(2, '0');
            document.getElementById('clock').textContent = `${hours}:${minutes}:${seconds}`;
        }
        setInterval(updateClock, 1000);
        updateClock();
    </script>
</body>
</html>
